clearvars
close all
clc
%% Load Data With flooding extent for salt marshes
load Flood_Marhses_OPEN.mat
load Flood_Marhses_MOSE.mat
load Flood_Marhses_ATHOS.mat
%% Load Data With flooding extent for Venice city
load Flood_Venice_OPEN.mat
load Flood_Venice_MOSE.mat
load Flood_Venice_ATHOS.mat
%% 
figure()
subplot(1,2,1)
hold on
boxplot([Flood_Venice_OPEN, Flood_Venice_MOSE, Flood_Venice_ATHOS], ...
    'Labels', {'OPEN', 'MOSE', 'ATHOS'})

% Jitter for point distriburtion
jitterAmount = 0.3;
% 1. OPEN
x1 = 1 + (rand(size(Flood_Venice_OPEN)) - 0.5) * jitterAmount;
scatter(x1, Flood_Venice_OPEN, 20, 'b', 'filled', 'MarkerFaceAlpha', 0.4)
% 2. MOSE
x2 = 2 + (rand(size(Flood_Venice_MOSE)) - 0.5) * jitterAmount;
scatter(x2, Flood_Venice_MOSE, 20, 'r', 'filled', 'MarkerFaceAlpha', 0.4)
% 3. ATHOS
x3 = 3 + (rand(size(Flood_Venice_ATHOS)) - 0.5) * jitterAmount;
scatter(x3, Flood_Venice_ATHOS, 20, 'g', 'filled', 'MarkerFaceAlpha', 0.4)
ylabel('Flooded Area (%)')
ylim([-5 105])
title('Venice Historic Centre')
hold off

subplot(1,2,2)
hold on
boxplot([Flood_Marshes_OPEN, Flood_Marshes_MOSE, Flood_Marshes_ATHOS], ...
    'Labels', {'OPEN', 'MOSE', 'ATHOS'})

% Jitter for point distriburtion
jitterAmount = 0.3;
% 1. OPEN
x1 = 1 + (rand(size(Flood_Marshes_OPEN)) - 0.5) * jitterAmount;
scatter(x1, Flood_Marshes_OPEN, 20, 'b', 'filled', 'MarkerFaceAlpha', 0.4)
% 2. MOSE
x2 = 2 + (rand(size(Flood_Marshes_MOSE)) - 0.5) * jitterAmount;
scatter(x2, Flood_Marshes_MOSE, 20, 'r', 'filled', 'MarkerFaceAlpha', 0.4)
% 3. ATHOS
x3 = 3 + (rand(size(Flood_Marshes_ATHOS)) - 0.5) * jitterAmount;
scatter(x3, Flood_Marshes_ATHOS, 20, 'g', 'filled', 'MarkerFaceAlpha', 0.4)
ylim([-5 105])
title('Salt Marshes')